# -*- coding: utf-8 -*-
"""
Created on Mon Dec 30 10:39:10 2019

@author: Takashi Sato

Complex Reaction System Laboratory
    
Copyright (c) 2022 Takashi Sato
    
This software is released under the MIT License. http://opensource.org/licenses/mit-license.php*/

"""
# from binomial_157.py


import element_29 as ce
import reaction_38 as rc
import utility_38 as ut
import reactionManage_03 as rm
import polymer_11 as po
import sys, os
import time
import datetime
import random

elms = ce.allElements()
reacs = rc.allReaction()
timeM = ut.timeManage()
utils = ut.Utility()
creR = rm.createReaction()
poly = po.Polymer()

t1 = time.time()
TimeDataPrint = "YES"
ParameterStudy = "NO"
ShowInSpyder = "YES"
CalculationOrder = " "  # "random" or " "


print(os.getcwd())
os.chdir('..')
print(os.getcwd())
# needs this dummy name
fName = "DUMMY"

'''
You need a input file to run from the Spyder.
'''
# select a input file
# fName = 'inp_immune_323.txt'
# fName = "inp_hill_008.txt"
# fName = "inp_feedback_405_14.txt"
# fName = "inp_feedforward_003_03.txt"
# fName = "inp_circadian_010.txt"
# fName = "inp_autocatalytic_111.txt"
# fName = "inp_geneticDrift_130.txt"
# fName = "inp_Lotka-Volterra_506_04.txt"
# fName = 'inp_test_031.txt'

# select a input file
# fName = 'inp_Glycolysis_90.txt'
# fName = 'inp_polymer_182.txt'
# fName = "inp_feedback_403.txt"
# fName = "inp_oscillation_008.txt"
# fName = "inp_exponential_402.txt"
fName = "inp_autocatalytic_110.txt"
# fName = 'inp_SIR_004.txt'
    
fName, ShowInSpyder = ut.setFromTerminal(fName, ShowInSpyder)

ut.changeDirectory(fName)

class Binomial:
    
    def __init__(self):
        self.openReadFile(fName)  
        self.preperation()
        self.calculate()
        self.endStep()
        self.polymerStep()

    def openReadFile(self, fName):
        
        with open(fName, encoding="utf-8_sig") as f:   # windows needs encoding="utf-8_sig"
        
            flg = 0
            subFlg = 0
            normConst = 0
            
            for line in f:
                line_new = line.replace('\n','')
                line_sprit = [x.strip() for x in line_new.split(",")]
                    
                if line_sprit[0] == '' or '**' in line_sprit[0] or '#' in line_sprit[0]:
                    pass            
                else:
                    print(line_sprit)
                     
                    if line_sprit[0] == "*End":
                        flg = 0
                        
                    if   flg == "*Time":
                        timeM.setTime(line_sprit)
            
                    elif flg == "*Element":
                        elms.setElement(line_sprit)
                        
                    elif flg == "*ElementInOut":
                        elms.setElementInOut(line_sprit)
                        
                    elif flg == "*elementPolymer":
                        elms.setElementPolymer(line_sprit)
            
                    elif flg == "*Reaction":
                        if line_sprit[0] == 'rM' and subFlg == 0:
                            ls1 = line_sprit
                            subFlg += 1
                        elif subFlg == 1:               
                            ls2 = line_sprit
                            if len(ls2) == 1 or ls2[1] == None or ls2[1] == "":
                                ls2 =[ls2[0], str(normConst)]
                            subFlg += 1
                        elif subFlg == 2:               
                            ls3 = line_sprit
                            reacs.setReactionMulti(ls1, ls2, ls3, elms.allElements)
                            subFlg = 0
                        else:
                            reacs.setReaction(line_sprit, elms.allElements, normConst)
                        
                    elif flg == "*ReactionPolymer":
                        creR.createReactionPolymer(line_sprit, elms, reacs)
                        
                    elif flg == "*Plot":
                        utils.appendList(line_sprit, elms.allElements)
        
        
                    # flg for setting
                    if line_sprit[0] == "*Time":
                        flg = "*Time"
                        
                    elif   line_sprit[0] == "*Element":
                        flg = "*Element"
        
                    elif   line_sprit[0] == "*ElementInOut":
                        flg = "*ElementInOut"
        
                    elif   line_sprit[0] == "*ElementPolymer":  
                        flg = "*elementPolymer"
                        
                    elif line_sprit[0] == "*Reaction":
                        try:
                            normConst = int(float(line_sprit[1])) 
                        except ValueError as e:            
                            print("ValueError : ", e)
                            print("A number is required in the second term of the *Reaction line.")
                            sys.exit()   
                        flg = "*Reaction"
                        
                    elif line_sprit[0] == "*ReactionPolymer":   
                        reacs.all = int(float(line_sprit[1]))  
                        flg = "*ReactionPolymer"
                        
                    elif line_sprit[0] == "*Plot":
                        try:
                            utils.plotScale = line_sprit[1]
                        except:
                            utils.plotScale = "linear"
                        flg = "*Plot"
    
    # tempolary code
    # sys.exit()
    
    def preperation(self):
        # 2022.1.3
        for el in elms.InOutElements.values():
            el.calcSchedule(timeM)
        
        if TimeDataPrint == "YES":
            utils.makeFolder(fName)
    
    def calculate(self):
        
        for step in timeM.allTime:
        
            if step in timeM.printTimes:             # 2022.2.12
                aElNames = elms.allElements.keys()
                numE = [elem.n for elem in elms.allElements.values()]
                numR = [reac.rName for reac in reacs.allReactions.values()]
                print()
                print(f" Time ({timeM.unit}) :{step:8} !!!!!!!!!!!!!!!!!!!!!")
                print(" Numbers of Elements :  ", len(numE), "  \n" , numE)
                print(" Names of Elements :  ", "\n" , aElNames)        
                print(" Numbers of reactions :  ", len(numR), "  \n" , numR)
            
            # 2022.1.3
            for el in elms.InOutElements.values():
                if step in el.schedule and step != 0:
                    index = el.schedule.index(step)
                    el.n = el.n + el.deltaN[index]
                    if el.n < 0:                                # 2022.9.3
                        el.n = el.n - el.deltaN[index]
            
            reactions = [v for v in reacs.allReactions.values()]
            
            if CalculationOrder == "random":    # 2022.6.22
                random.shuffle(reactions)
            else:
                pass
               
            if step == timeM.startTime:       # 2022.8.28
                pass
            else:
                for re in reactions:
                    re.react()
                for el in elms.allElements.values():
                    el.updateNumbers()
        
            if step in timeM.plotTimes:            # 2022.8.28　ここに移動
                tRange = [t for t in range(timeM.startTime, step + 1)]
                utils.plotSome(tRange, step, timeM.unit, fName, TimeDataPrint, ShowInSpyder)              
                if "polymer" in fName:
                    poly.plotDistribution(step, utils, fName, elms, TimeDataPrint, ShowInSpyder)
        
            if TimeDataPrint == "YES" and step == timeM.endTime:
                print("Print times: ", timeM.getPrintTimes())
                utils.saveCsvFiles(step, timeM.getCsvTimes(), fName, elms, timeM)
                utils.saveCsvFiles_02(step, timeM.getCsvTimes(), fName, elms, timeM)
    
    def endStep(self):
        t2 = time.time()
        elapsed_time = t2 - t1
        td = datetime.timedelta(seconds=elapsed_time)
        print()
        print(f"Elapsed_time : {td}")
    
    def polymerStep(self):    
        if "polymer" in fName:
            poly.plotMWD_atAnyTime_02(timeM, utils, fName, elms, TimeDataPrint, poly.getMaxDegrees(elms.polymers), ShowInSpyder)  # 2022.2.11
            poly.calculateMwMn(utils, timeM, fName, elms, TimeDataPrint)
            poly.saveDistribution(utils, timeM, fName)
            poly.plotMwMn(utils, timeM, fName, ShowInSpyder)
 
    
# run Binomial
bi = Binomial()

