# -*- coding: utf-8 -*-
"""
Created on Sun Jun  7 15:19:35 2020

@author: takashi

Complex Reaction System Design Laboratory
    
Copyright (c) 2022 Takashi Sato
    
This software is released under the MIT License. http://opensource.org/licenses/mit-license.php*/

"""

import random, sys
import numpy as np
import collections
import matplotlib

colorDict = matplotlib.colors.cnames

    
colors = ['Black', 'Green' ,'Yellow', 'Gray', 'Blue', 'Red', 'Orange']

class Element(object):    

    def __init__(self, name, initial, color, realName = "", \
                       type = "", vol = 1.0, volUnit = "-"): 
        
        self.name = name
        self.n = initial         
        self.color = color
        self.currentNums = [initial, ]
        self.realName = realName
        self.type = type
        self.volume = float(vol)
        self.volumeUnit = volUnit        
        print("A element, ", name, initial, color, realName, type, self.volume, "created. ")
    
    def setNum(self, n):
        self.n = n
        self.currentNums.append(n) 
        
    def increase(self, dn):
        self.n += dn        

    def decrease(self, dn):
        self.n -= dn        
        
    def updateNumbers(self):
        self.currentNums.append(self.n) 
        
    def getN(self):
        return self.n
    
    def  getVolume(self):
        return self.volume
    
    # def getConcentration(self, totalVolume):
    #     nMax = totalVolume/self.volume
    #     return self.n/nMax
    
    # def getConcentration2(self, totalVolume, before):
    #     nMax = totalVolume/self.volume
    #     return self.n/nMax


class ElementPolymer(Element):
    
    def __init__(self, name, initial, color, ls5, deg, ls6, ls7):
        self.degrees = deg
        
        print(f" self.degrees: {self.degrees}")
        super().__init__(name, initial, color, name, ls5, ls6, ls7)
    

class ElementInOut(Element):
    
    def __init__(self, name, initial, color, realName = "", type = "", \
                  vol = 1.0, volUnit = "-", schedule_type = "0", *args):
        super().__init__(name, initial, color, realName, type,  \
                          vol, volUnit)
        
        self.schedule_type = schedule_type
        self.args = args        
        self.schedule = []
        self.deltaN = []        
        print(" ElementInOut:  ", self.schedule_type, self.args)

    def calcSchedule(self, timeM):
        print("Calculate schedule for ElementInOut")        
        start = timeM.startTime
        end = timeM.endTime
        print(start, end)
        print(self.schedule_type)        
        if self.schedule_type == "1":
            a = int(self.args[0][0])
            d = int(self.args[0][1])
            self.schedule = [ t for t in range(start, end, a) ]
            self.deltaN = [ d for i in range(len(self.schedule)) ]
            self.deltaN[0] = self.n
        elif self.schedule_type == "2":
            s = int(self.args[0][0])
            a = int(self.args[0][1])
            T = int(self.args[0][2])
            d = int(self.args[0][3])
            self.schedule = [ t for t in range(start, end, d) ]
            self.deltaN = [ int(s + a*np.sin(2*np.pi*t*d/T)) for t in range(len(self.schedule)) ]            
            self.deltaN[0] = self.n

        print(self.schedule[:100], "\n", self.deltaN[:100])
    
    def getSchedule(self):
        pass


class allElements:

    def __init__(self):  
        self.allElements = {} 
        self.polymers = {}
        self.distributionOfPolymer = {}
        self.InOutElements = {}
    
    def setElement(self, ls):                                # needs refactering
        
        name, initial, color = self.lineSprit(ls)
        
        try:
            realName = ls[3]
            realName = name if realName == "" else ls[3].replace(' ', '')
        except:
            realName = name
             
        try:
            type = ls[4]
            type = "?" if type == "" else ls[4].replace(' ', '')         
        except:
            type = "?"
            
        try:
            volume = ls[5]
            volume = 1.0 if volume == "" else float(ls[6].replace(' ', ''))  
        except:
            volume = 1.0
            
        try:
            vUnit = ls[6]
            vUnit = "-" if vUnit == "" else ls[7].replace(' ', '') 
        except:
            vUnit = "-"
            
        # print(name, initial, color, realName, type, degrees, volume, vUnit)
        sa = Element(name, initial, color, realName, type, volume, vUnit)
        self.allElements[name] = sa


    def lineSprit(self, ls):
        
        name = ls[0].strip()
        initial = ls[1]
        color = ""
        
        try:
            initial = 0 if initial == "" else int(float(initial))
        except:
            initial = 0
        
        try:
            color = random.choice(list(colorDict.values())) if ls[2] == "" else ls[2].replace(' ', '')
        except:
            color = random.choice(list(colorDict.values())) 
        
        return name, initial, color

                
    def makeBasicEls(self, elN, usedBasicNames, maxTBNinEl):
        basicEls = []
        for i in range(elN):
            selected = random.choices(usedBasicNames, k = random.randint(1, maxTBNinEl))
            selectDic = dict(collections.Counter(selected))  
            basicEls.append(selectDic) 
        return basicEls 
      
    def makeName(self, basicEls):
        elNames = []
        for el in basicEls:
            name = ""
            for k , v in el.items():
                name += k + "=" + str(v) + "_"
            name = name[:-1]
            elNames.append(name)
        return elNames

    def setNewLines(self, elNames, basicEls, initial3):
        for elName, elel in zip(elNames, basicEls):
            if elName in self.allElements.keys():
                # print(f"!! !! !!  Element  {elName} already exists !! !! !! ")
                pass
            else:
                colorName, colorCode = random.choice( list(colorDict.items()) )
                line = [elName, initial3, colorCode, " - ", "x", elel ]              # x means autoElement
                self.setElement(line)


    """
    define a element if There is NO in *Reaction.  Not usedで
    """
    def setElementFromUtility(self, eName):
        if eName in self.allElements.keys():
            # print(f"!! !! !!  Element  {eName} already exists !! !! !! ")
            pass
        else:
            # print(f"!! !! !! New element  {eName} created !! !! !!")
            # initial = 0
            color = random.choice( list(colorDict.values()) )        
            # category = 'x'
            self.setElement([eName, 0, color, " - ", 'x', 0])


    def setElementInOut(self, ls):
        print("ls: ", ls)
        name, initial, color = self.lineSprit(ls[:3])
        sa = ElementInOut(name, initial, color, name, "InOut", 1, 1.0, ls[7], ls[8:])
        self.InOutElements[name] = sa
        self.allElements[name] = sa


    def setElementPolymer(self, ls):     
        nameChrList = list(ls[0])
        print(nameChrList)
        # This if-code should go to Polymer class.
        if "M" not in nameChrList:
            print()
            print("***  Error  ***")
            print("Use \"M\" for monomer in Polymerization process!!")                       
            sys.exit()
        for deg in range(int(ls[1]), int(ls[2]) + int(ls[3]) , int(ls[3])):
            nameChrList = list(ls[0])
            indx = [i for i, x in enumerate(nameChrList) if x == '*']
            nameChrList[indx[0]] = str(deg) 
            newName = ''.join(nameChrList)
            name, initial, color = self.lineSprit([newName, ls[4], ""])
            be = ElementPolymer(name, initial, color, ls[5], deg, ls[6], ls[7])
            self.allElements[newName] = be
            self.polymers[newName] = be




            
            